#include <cstdint>
#include <iostream>
#include <memory>
#include <sstream>


std::unique_ptr<uint64_t[]> int_arr_input(const uint64_t len) {
  std::string input;
  std::getline(std::cin, input, '\n');
  auto out = std::make_unique<uint64_t[]>(len);
  std::istringstream iss(input);
  for (int i = 0; i < len; i++) {
    iss >> out[i];
  }
  return out;
}

int main() {
  uint64_t arrLen;
  std::cin >> arrLen;
  std::cin.ignore();
  auto arr1 = int_arr_input(arrLen);
  std::cin.ignore();
  auto arr2 = int_arr_input(arrLen);

  uint64_t maxValXor = 0; 
  uint64_t maxValAnd = 0; 

  for (uint64_t i = 1; i < arrLen; i++) {
    uint64_t valXor = arr1[i-1] ^ arr1[i]; 
    if (valXor > maxValXor) {
      maxValXor = valXor;
    }
  }

  for (uint64_t i = 1; i < arrLen; i++) {
    uint64_t valAnd = arr2[i-1] & arr2[i]; 
    if (valAnd > maxValAnd) {
      maxValAnd = valAnd;
    }
  }

  std::cout << maxValXor * maxValAnd << '\n';
  return 0;
}